DROP PROCEDURE [hips].[ContactGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Gordon
-- Create date: 15 Oct 2012
-- Description:   Gets a specific record from the Country Table
-- =============================================
CREATE PROCEDURE [hips].[ContactGet] 
(
	@ContactId INT = null
)
AS
BEGIN
	SELECT  c.ContactId,
			c.Detail,
			c.ContactMethodId,
			cm.TelecommunicationType,
			cm.Description,
			cm.CdaType,
			c.DateCreated,
			c.UserCreated,
			c.DateModified,
			c.UserModified
			
	FROM  hips.Contact c
	INNER JOIN hips.ContactMethod AS cm ON cm.ContactMethodId = c.ContactMethodId
	WHERE c.ContactId = @ContactId OR @ContactId IS NULL
END
GO

